@echo off
IF EXIST tools\%1.bat goto okay1
install.bat wav 22050
:okay1

echo.
echo -----------------------------------------------------------------
echo - The Secret of Monkey Island - Ultimate Talkie Edition Builder -
echo -----------------------------------------------------------------
echo version 1.0
echo (running in %1 mode)
echo.

IF EXIST ..\Monkey1.pak goto okay2
goto failpak
:okay2

IF EXIST tools\xWMAEncode.exe goto okay3
goto failxwma
:okay3

md MI1_Ultimate_Talkie_Edition
copy >nul: readme.txt MI1_Ultimate_Talkie_Edition /y
cd tools

echo This patch will take about 15-30 minutes, depending on your hardware.
echo Please be patient while I'm busy.
echo.

call voice.bat

IF EXIST ..\MI1_Ultimate_Talkie_Edition\monkey.000 goto resource_done
echo.
echo extracting classic resources
extract_classic
IF %ERRORLEVEL% NEQ 0 pause

echo.
echo patching scripts
bspatch monkey1.000 monkey.000 patch10.000
IF %ERRORLEVEL% NEQ 0 pause
bspatch monkey1.001 monkey.001 patch10.001
IF %ERRORLEVEL% NEQ 0 pause

echo.
echo implementing high quality sounds
call sbl 22050
copy Resource.000 ..\MI1_Ultimate_Talkie_Edition\monkey.000 /y
copy Resource.001 ..\MI1_Ultimate_Talkie_Edition\monkey.001 /y
del >nul Resource.000
del >nul Resource.001
del >nul monkey.000
del >nul monkey.001
del >nul monkey1.000
del >nul monkey1.001
:resource_done

call %1.bat %2
IF EXIST monster.sou copy monster.sou ..\MI1_Ultimate_Talkie_Edition /y
IF EXIST monkey.sof copy monkey.sof ..\MI1_Ultimate_Talkie_Edition /y
IF EXIST monkey.sog copy monkey.sog ..\MI1_Ultimate_Talkie_Edition /y
IF EXIST monkey.so3 copy monkey.so3 ..\MI1_Ultimate_Talkie_Edition /y

echo.
echo cleaning up.
IF EXIST monster.sou del >nul monster.sou
IF EXIST monkey.sof del >nul monkey.sof
IF EXIST monkey.sog del >nul monkey.sog
IF EXIST monkey.so3 del >nul monkey.so3
del >nul *.%1

IF NOT %1==wav goto exe_done
IF EXIST ..\MI1_Ultimate_Talkie_Edition\monkey.exe goto exe_done
echo.
echo patching SCUMM for DOS
7z e fatecd.exe atlantis.exe adlib.ims rol_330.ims rol_332.ims rol_334.ims rol_336.ims speaker.ims
IF %ERRORLEVEL% NEQ 0 pause
7z e dottcd.exe gmidi.ims
IF %ERRORLEVEL% NEQ 0 pause
ren gmidi.ims gmidi.im_
bspatch atlantis.exe monkey.exe patch05.ex_
IF %ERRORLEVEL% NEQ 0 pause
bspatch gmidi.im_ gmidi.ims patch05.im_
IF %ERRORLEVEL% NEQ 0 pause
copy monkey.exe ..\MI1_Ultimate_Talkie_Edition /y
copy *.ims ..\MI1_Ultimate_Talkie_Edition /y
del >nul: atlantis.exe
del >nul: monkey.exe
del >nul: gmidi.im_
del >nul: *.ims
:exe_done

call cdaudio.bat %1

echo.
echo -----------------------------------------------------------------
echo - The Secret of Monkey Island - Ultimate Talkie Edition Builder -
echo -----------------------------------------------------------------
echo All work is done.
echo (as long as there weren't any error messages)
echo.

goto end

:failpak
cls
echo Monkey1.pak not found.
echo You should put the MI1_Ultimate_Talkie_Edition_Builder folder
echo where your Monkey1.pak is located,
echo and then run install.bat inside it.

goto end

:failxwma
cls
echo xWMAEncode.exe not found inside the tools subfolder.
echo You should put the file xWMAEncode.exe there.
echo The file is part of Microsoft's Direct X sdk.
echo You may find it separately, but must agree to their EULA nevertheless.

:end
pause